/*-------------------------------------------------------*
*  Name:      SelectNotify.zmp                           *
*  Purpose:   Notifies on changes in selection.          *
*  Authors:   Oleg M.                                    *
*                                                        *
*  History:   1.October.01 - project started             *
*                                                        *
*-------------------------------------------------------*/

#include <struct.h>

DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}


DWORD CALLBACK Supports(long)
{
  return Z3D_PLUGSUPPORTS_PROCESSING;
}

DWORD CALLBACK DynamicLoading(long)
{
  return 0; // DLL will be loaded ones.
}

DWORD CALLBACK GetProcsAmount(long)
{
  return 1;
}

DWORD CALLBACK PlaceType(long num)
{
  return Z3D_EVENT_SELECTIONCHANGED;
}

char* CALLBACK GetProcName(long num)
{
  return "SelectNotify";
}



//------------------------------------------------------------------
// the tool goes here.

//------------------------------------------------------------------
// Usually, each tool is implemented in separate CPP file, but for
// the sake of brivety, in this tutorial, all the functions and tools
// are implemented in one file.
DWORD CALLBACK SelectNotifyPost(tProcParams* params)
{
  int nSel  = 0;
  int nHidd = 0;
  char message[128];
  if (CurrentState.IsLevel(Z3D_LEVEL_EDGES) ||
    CurrentState.IsLevel(Z3D_LEVEL_SPLINES) ||
    CurrentState.IsLevel(Z3D_LEVEL_SPLINEVERTICES) ||
    CurrentState.IsLevel(Z3D_LEVEL_NONE))
    return 0;

  char LevelStr[16];
  wsprintf(LevelStr, CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) ?
    "object(s)" : CurrentState.IsLevel(Z3D_LEVEL_FACES) ? "face(s)" : "vertices");

  for (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
    {
      if (params->Objects->ObjSet[ObjCount].Selected())
      {
        nSel++;
        if (params->Objects->ObjSet[ObjCount].Hidden())
          nHidd++;
      }
    }
    else
    {
      tObject* pObj = &params->Objects->ObjSet[ObjCount];
      if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
        for (FaceCount = 0; FaceCount < pObj->FaceTable->FaceAmount; FaceCount++)
        {
          if (pObj->FaceTable->Selected(FaceCount))
          {
            nSel++;
            if (pObj->FaceTable->Hidden(FaceCount))
              nHidd++;
          }
        }
      if (CurrentState.IsLevel(Z3D_LEVEL_VERTICES))
        for (VertCount = 0; VertCount < pObj->VertTable->VertAmount; VertCount++)
        {
          if (pObj->VertTable->Selected(VertCount))
          {
            nSel++;
            if (pObj->VertTable->Hidden(VertCount))
              nHidd++;
          }
        }
    }
  sprintf(message, "%u %s is selected. %u is hidden amoung them.", nSel, LevelStr, nHidd);
  CurrentState.SetMessage(message);

  return Z3D_PLUGRESULT_UPDATEMESSAGE;
}
